#include <CtrlLib/CtrlLib.h>
#include "line_edit_extended_ctrl.h"

using namespace Upp;

class MainWindowDlg : public TopWindow {

	typedef MainWindowDlg CLASSNAME;
	
	public:
		MainWindowDlg(){
            
            HCenterPosZ(640).VCenterPosZ(400);
            lb.TopPosZ(10,15).HSizePosZ(10,10);
            tx1.VSizePosZ(40,70).LeftPosZ(10,200);
            tx2.VSizePosZ(40,70).LeftPosZ(220,200);
            tx3.VSizePosZ(40,70).LeftPosZ(430,200);

            tx4.VSizePosZ(40,70).LeftPosZ(10,200);
            tx5.VSizePosZ(40,70).LeftPosZ(220,200);
            tx6.VSizePosZ(40,70).LeftPosZ(430,200);
            
            b.BottomPosZ(10,50).RightPosZ(10,200);
            b.SetLabel("Use LineEdit");
            b.WhenPush=THISBACK(ToggleFix);
            
            this<<tx1<<tx2<<tx3<<tx4<<tx5<<tx6<<b<<lb;
			
			for(int i=0; i<10; i++) tmp<<"Hello World "<<i<<"\n";
			
			LoadDemoText(); 
			                        
            tx1.SetReadOnly();
            tx4.SetReadOnly();
            
            ToggleFix();
                 		
		}
	
		void LoadDemoText(){
           
			 tx1.Set(tmp);
			 tx4.Set(tmp);
             tx3.Set(tmp);
             tx6.Set(tmp);
             
             tx2.Clear();
             tx5.Clear();
             			
		}
		
		void ToggleFix(){
			
			LoadDemoText();
			
			if(b.GetLabel()=="Use LineEditExtended"){
							
				tx4.Hide();
				tx5.Hide();
				tx6.Hide();
				tx1.Show();
				tx2.Show();
				tx3.Show();
				
				b.SetLabel("Use LineEdit");
				lb.SetText("Using LineEditExtended. Try Dragging text out of ReadOnly Ctrl...");				
			}
			else{
				tx4.Show();
				tx5.Show();
				tx6.Show();
				tx1.Hide();
				tx2.Hide();
				tx3.Hide();
				
				b.SetLabel("Use LineEditExtended");
				lb.SetText("Using LineEdit. Try Dragging text out of ReadOnly Ctrl...");				
			}
				
	

			
		}
		
	private: 
		LineEditExtended tx1, tx2,tx3;
		LineEdit tx4, tx5, tx6;
		
		Button b;
		Label lb;
		
		String tmp;

};

GUI_APP_MAIN
{
    MainWindowDlg w;
    
    w.Run();

}
